function AISMN_FadeIn::OnEnter(%this,%obj)
{
   %object = GetThisObject(%obj);
   %object.showMesh(true);
   if(%object.isServerObject())
      %object.startFade(1000, 0, false);
   return;
}

function AISMN_FadeIn::OnExit(%this,%obj)
{
   %object = GetThisObject(%obj);
   if (%object.isServerObject() == true)
   {
      %ghostID = slgGetGhostIndex(%object);
      EnableCollision(%ghostID);
   }
   return;
}

function AISMN_FadeIn::Update(%this,%obj)
{
   %timePassed = TimeInNode(%obj);
   if(!GetThisObject(%obj).isFading() || %timePassed >= 1)
      ReturnValue(%obj,0);
   else
      ReturnValue(%obj,-1);
   return;
}

function EnableCollision(%obj)
{
   %count = ClientGroup.getCount();
   for (%i = 0; %i < %count; %i++)
   {
      %cl = ClientGroup.getObject(%i);
      commandToClient(%cl, 'EnableCollision', %obj);
   }
}
